/*
Half-Life MAP viewing utility.
Copyright (C) 2003  Ryan Samuel Gregg

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#pragma once
#include "stdafx.h"

__sealed __gc class CPointFile
{
private:
	CConfig *Config;

	int iNumPoints;
	Vertex3f *Vertices;

public:
	CPointFile(CConfig *Config, int iNumPoints)
	{
		this->Config = Config;
		this->iNumPoints = iNumPoints;

		Vertices = new Vertex3f[iNumPoints];
	}

	~CPointFile()
	{
		delete []Vertices;
	}
	
	void SetVertex(int iIndex, Vertex3f Vertex)
	{
		Vertices[iIndex] = Vertex;
	}

	void DrawPoints()
	{
		if(!Config->bDrawPointFile)
			return;

		glEnable(GL_DEPTH_TEST);
		glDisable(GL_CULL_FACE);
		glDisable(GL_TEXTURE_2D);
		glColor3ub(255, 0, 0);

		glEnableClientState(GL_VERTEX_ARRAY);
		glVertexPointer(3, GL_FLOAT, sizeof(Vertex3f), Vertices);

		glDrawArrays(GL_LINE_STRIP, 0, iNumPoints);

		glEnableClientState(GL_VERTEX_ARRAY);
	}
};